<!doctype html>
<html lang="en">

<head>
    <title>Agenda Web</title>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <!-- Bootstrap CSS v5.2.1 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous" />

    <!-- CSS FULL CALENDAR -->
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/main.js"></script>
    <!-- JS FULL CALENDAR -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/main.css">

    <!-- TRADUCCION FULL CALENDAR -->
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/locales-all.js"></script>


</head>

<body>
    <header>
        <!-- place navbar here -->

    </header>
    <main>

        <!-- MOSTRAMOS EL CALENDARIO -->
        <div class="container">
            <div class="col-md-10 offset-md-1">
                <div id='calendar'></div>
            </div>
        </div>

        <!-- BOTON DEL MODAL -->
        <button type="button" class="btn btn-primary btn-lg" data-bs-toggle="modal" data-bs-target="#modalEvento">
            Launch
        </button>

        <!-- MODAL -->
        <div class="modal fade" id="modalEvento" tabindex="-1" role="dialog" aria-labelledby="modalTitleId" aria-hidden="true">

            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <!-- CABECERA MODAL -->
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalTitleId">
                            Datos del Evento
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- FORMULARIO MODAL -->
                    <div class="modal-body">
                        <div class="container-fluid">
                            <form action="" method="post">
                                <div class="mb-3">

                                    <!-- ID oculto name="id" id="id" -->
                                    <div class="mb-3 visually-hidden ">
                                        <label for="id" class="form-label">ID:</label>
                                        <input type="text" class="form-control" name="id" id="id" aria-describedby="helpId" placeholder="ID">
                                    </div>

                                    <!-- ID oculto name="idu" id="idu" -->
                                    <div class="mb-3 visually-hidden ">
                                        <label for="idu" class="form-label">ID:</label>
                                        <input type="text" class="form-control" name="idu" id="idu" aria-describedby="helpId" placeholder="ID">
                                    </div>

                                    <!-- Titulo name="titulo" id="titulo" -->
                                    <div class="mb-3">
                                        <label for="titulo" class="form-label">Título</label>
                                        <input type="text" class="form-control" name="titulo" id="titulo" aria-describedby="helpId" placeholder="Título">

                                    </div>

                                    <!-- Fecha name="fecha" id="fecha" -->
                                    <div class="mb-3">
                                        <label for="fecha" class="form-label">Fecha:</label>
                                        <input type="date" class="form-control" name="fecha" id="fecha" aria-describedby="helpId" placeholder="Fecha:">

                                    </div>

                                    <!-- Hora name="hora" id="hora" -->
                                    <div class="mb-3">
                                        <label for="hora" class="form-label">Hora del evento:</label>
                                        <input type="time" class="form-control" name="hora" id="hora" aria-describedby="helpId" placeholder="Hora:">
                                    </div>

                                    <!-- Hora name="descripcion" id="descripcion" -->
                                    <div class="mb-3">
                                        <label for="descripcion" class="form-label">Descripción</label>
                                        <textarea class="form-control" name="descripcion" id="descripcion" rows="3"></textarea>
                                    </div>

                                    <!-- name="color" id="color" -->
                                    <div class="mb-3">
                                        <label for="color" class="form-label">Color:</label>
                                        <input type="color" class="form-control" name="color" id="color" aria-describedby="helpId" placeholder="Color:">

                                    </div>
                                </div>

                            </form>
                        </div>


                    </div>

                    <!-- FOOTER MODAL -->
                    <div class="modal-footer">

                        <!-- BOTÓN CIERRE -->
                        <button id="btnBorrar" onclick="borrarEvento()" type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            Borrar
                        </button>

                        <!-- BOTÓN GUARDAR -->
                        <button id="btnGuardar" onclick="agregarEvento()" type="button" class="btn btn-primary">
                            Guardar
                        </button>
                    </div>
                </div>
            </div>
        </div>

    </main>
    <footer>
        <!-- place footer here -->
    </footer>




    <!-- Bootstrap JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js" integrity="sha384-BBtl+eGJRgqQAUMxJ7pMwbEyER4l1g+O15P+16Ep7Q9Q+zqX6gSbd85u4mG4QzX+" crossorigin="anonymous"></script>

    <!-- JS Inicializa Full Calendar id 'calendar' -->
    <script>
        var usuario = 1;
        var modalEvento;
        modalEvento = new bootstrap.Modal(document.getElementById('modalEvento'), {
            keyboard: false
        });

        var calendar;

        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                /* Traducir al español */
                locale: "es",
                /* Configurar la barra de herramientas  */
                headerToolbar: {
                    left: 'prev,next,today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },

                dateClick: function(informacion) {
                    limpiarFormulario(informacion.dateStr);
                    //alert('Presionaste ' + informacion.dateStr);
                    limpiarErrores();
                    modalEvento.show();
                },
                eventClick: function(informacion) {
                    //alert("Presionaste un evento");
                    console.log(informacion);
                    limpiarErrores();
                    modalEvento.show();
                    recuperarDatosEventos(informacion.event);
                },

                events: "api.php?usuario="+usuario

            });
            calendar.render();
        });
    </script>
    <script>
        function recuperarDatosEventos(evento) {
            limpiarErrores();

            var fecha = evento.startStr.split("T");
            var hora = fecha[1].split(":");

            document.getElementById('id').value = evento.id;
            document.getElementById('titulo').value = evento.title;
            document.getElementById('fecha').value = fecha[0];
            document.getElementById('hora').value = hora[0] + ":" + hora[1];
            document.getElementById('descripcion').value = evento.extendedProps.descripcion;
            document.getElementById('color').value = evento.backgroundColor;

            document.getElementById('btnBorrar').removeAttribute('disabled', "");
            document.getElementById('btnGuardar').removeAttribute('disabled', "");
        }

        function agregarEvento() {


            if (document.getElementById('titulo').value == "") {
                document.getElementById('titulo').classList.add('is-invalid');
                return true;
            }

            if (document.getElementById('fecha').value == "") {
                document.getElementById('fecha').classList.add('is-invalid');
                return true;
            }

            if (document.getElementById('hora').value == "") {
                document.getElementById('hora').classList.add('is-invalid');
                return true;
            }

            accion = (document.getElementById("id").value == 0) ? "agregar" : "actualizar";
            enviarDatosApi(accion);
        }

        function borrarEvento() {
            if (confirm("Borrar?")) {
                enviarDatosApi("borrar");
            }

        }

        function enviarDatosApi(accion) {
            fetch("api.php?accion=" + accion, {
                    method: "POST",
                    body: recolectarDatos()
                })

                .then(
                    data => {
                        console.log(data);
                        RefrescarCalendario();
                        modalEvento.hide();
                    }
                )

                .catch(error => {
                    console.log(error);
                })
        }


        function recolectarDatos() {
            var evento = new FormData();

            evento.append("id", document.getElementById('id').value);

            evento.append("title", document.getElementById('titulo').value);
            evento.append("date", document.getElementById('fecha').value);
            evento.append("time", document.getElementById('hora').value);
            evento.append("descr", document.getElementById('descripcion').value);
            evento.append("color", document.getElementById('color').value);
            //console.log(evento.get("title"));

            return evento;

        }

        function limpiarFormulario(fecha) {
            limpiarErrores();
            document.getElementById('titulo').value = "";
            document.getElementById('fecha').value = fecha;
            document.getElementById('hora').value = "12:00";
            document.getElementById('descripcion').value = "";
            document.getElementById('color').value = "";
            document.getElementById('id').value = "";

            document.getElementById('btnBorrar').setAttribute('disabled', "disabled");
        }

        function limpiarErrores() {
            document.getElementById('titulo').classList.remove('is-invalid');
        }

        function RefrescarCalendario() {
            calendar.refetchEvents();
        }

    </script>
</body>

</html>